/* FC_LoadFloatProfile.mq4 - Load default float profile or named float profile.
 * Default or named profile must have been previously saved under the same
 * MetaTrader profile.
 *
 * This content is released under the terms of the MIT license.
 * A copy of this license has been included with this project in LICENSE.txt
 */
#property copyright   "Copyright (c) 2015 TradertoolsFX"
#property link        "http://www.tradertools-fx.com"
#property strict

//#define LASTSTATE // If defined, hide inputs and just load default profile.
#ifndef LASTSTATE
#property show_inputs
#endif

#include "../inc/fcprecheck.mqh"
#include "../inc/fcprofiles.mqh"

input string _desc_ = "== Leave ProfileName blank to load the default float profile ==";
input string ProfileName = "";

void OnStart()
{
    FloatingCharts fc;
    if (FCPreCheck(fc) != FC_ERR_SUCCESS ||
            !fc.RequiresFC(3, 2, 0, true)) {
        return;
    }

    int fail_count = 0;

    // Open file for reading
    ResetLastError();
    int file_handle = FileOpen(GetFileName(GetProfileId(fc), ProfileName),
                               FILE_READ|FILE_BIN);
    if (file_handle == INVALID_HANDLE) {
        Alert("Failed to open float profile.",
              " The profile may not exist. Last error: ",
              GetLastError());
        return;
    }

    // Read file into array
    long chart_ids[];
    ResetLastError();
    if (FileReadArray(file_handle, chart_ids) == 0) {
        Alert("Failed to read from file! Last error: ", GetLastError());
    } else {
        // Start fresh
        fc.UnfloatAll();

        // Float saved charts
        for (int i = 0; i < ArraySize(chart_ids); i++) {
            if (fc.Float(chart_ids[i]) != FC_ERR_SUCCESS) {
                Print("Failed to float chart ... it may not exist anymore");
                fail_count++;
            }
        }
    }

    FileClose(file_handle);

    // Report status if errors
    if (fail_count > 0) {
        Alert("Float profile loaded, but ",
              fail_count,
              " charts failed to float. They may no longer exist ...");
    }
}
