/* FC_RestoreMinimized.mq4 - Restore all minimized floating charts.
 *
 * This content is released under the terms of the MIT license.
 * A copy of this license has been included with this project in LICENSE.txt
 */
#property copyright   "Copyright (c) 2015 TradertoolsFX"
#property link        "http://www.tradertools-fx.com"
#property version     "1.0"
#property strict

#include "inc/fcprecheck.mqh"

#define SW_RESTORE 9

void OnStart()
{
    FloatingCharts fc;

    if (FCPreCheck(fc) != FC_ERR_SUCCESS) {
        return;
    }

    long chart_id = ChartFirst();
    int chart_frame_window = 0;

    while (!IsStopped() &&
           chart_id != -1) {
        if (fc.IsChartFloating(chart_id)) {
            chart_frame_window = GetChartFrameWindow(chart_id);
            ShowWindow(chart_frame_window, SW_RESTORE);
        }

        chart_id = ChartNext(chart_id);
    }
}
