/* FC_FloatFirstNCharts.mq4 - Float up to N charts.
 * If the MT4 profile has less than N - 1 charts,
 * it will stop at the last chart in the profile.
 * NOTE: May not working properly on MT4 Floating charts version less than 3.2.0
 *
 * This content is released under the terms of the MIT license.
 * A copy of this license has been included with this project in LICENSE.txt
 */
#property copyright   "Copyright (c) 2015 TradertoolsFX"
#property link        "http://www.tradertools-fx.com"
#property version     "1.0"
#property strict
#property show_inputs

#include "inc/fcprecheck.mqh"

input int MaxCharts = 5;

void OnStart()
{
    FloatingCharts fc;
    if (FCPreCheck(fc) != FC_ERR_SUCCESS) {
        return;
    }

    int count = 0;
    long chart_id = ChartFirst();
    while (count < MaxCharts &&
           chart_id != -1 &&
           !IsStopped()) {
        if (fc.Float(chart_id) == FC_ERR_SUCCESS) {
            count++;
        }

        chart_id = ChartNext(chart_id);
    }
}
