/* FC_AutoRotator.mq4 - auto rotate charts.
 *
 * This content is released under the terms of the MIT license.
 * A copy of this license has been included with this project in LICENSE.txt
 */
#property copyright   "Copyright (c) 2015 TradertoolsFX"
#property link        "http://www.tradertools-fx.com"
#property version     "1.0"
#property strict
#property show_inputs

#import "user32.dll"
    int BringWindowToTop(int hWnd);
#import

#include "inc/fcprecheck.mqh"

input int RotationIntervalInSeconds = 5;

void OnStart() {
    FloatingCharts fc;
    if (FCPreCheck(fc) != FC_ERR_SUCCESS) {
        return;
    }

    int pause_time = RotationIntervalInSeconds * 1000;
    int count = 0;
    long chart_id = ChartFirst();
    while (!IsStopped()) {
        if (fc.IsChartFloating(chart_id)) {
            count++;
            if (BringWindowToTop(GetChartFrameWindow(chart_id))) {
                Sleep(pause_time);
            }
        }

        chart_id = ChartNext(chart_id);

        if (chart_id == -1) {
            if (count == 0) { // No floating charts
                Print("No charts floating. Exiting ...");
                break;
            }

            // Restart
            chart_id = ChartFirst();
            count = 0;
        }
    }
}
