/**
 * @internal
 * @file windowmessages.mqh
 *
 * @license
 *  This content is released under the terms of the MIT license.
 *  A copy of this license has been included with this project in LICENSE.txt
 */
#property copyright "Copyright (c) 2015 TradertoolsFX"
#property link      "http://www.tradertools-fx.com"
#property strict

#include <WinUser32.mqh>

#ifdef _UNICODE
#define SendMessage SendMessageW
#else
#define SendMessage SendMessageA
#endif

#ifdef _UNICODE
#define PostMessage PostMessageW
#else
#define PostMessage PostMessageA
#endif

#define WM_USER                  0x0400

#define WM_INFO_REQUEST          WM_USER+3
#define WP_INFO_REQUEST_VERSION  551
#define WP_INFO_REQUEST_PING     552

// Float commands
#define COMMAND_ID_FLOAT        0xFEFC
#define COMMAND_ID_FLOAT_ALL    0xFEFD
#define COMMAND_ID_UNFLOAT_ALL  0xFEFE

// Custom toolbar
#define COMMAND_ID_FIRST_BUTTON  0x8765
#define CORNER_SNAP_1_OFFSET     0
#define CORNER_SNAP_2_OFFSET     1
#define CORNER_SNAP_3_OFFSET     2
#define CORNER_SNAP_4_OFFSET     3
#define PUSHBACK_OFFSET          4
#define SYMBOL_MAPPING_OFFSET    5
#define SYMBOL_STACKING_OFFSET   6
